/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.SlottedCraftingRequest;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.tile.TileExporter;
import com.raoulvdberge.refinedstorage.tile.config.FilterConfig;
import com.raoulvdberge.refinedstorage.tile.config.FilterType;
import com.raoulvdberge.refinedstorage.tile.config.IRSFilterConfigProvider;
import com.raoulvdberge.refinedstorage.tile.config.IUpgradeContainer;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeExporter
extends NetworkNode
implements IRSFilterConfigProvider,
ICoverable,
IUpgradeContainer {
    public static final String ID = "exporter";
    private static final String NBT_COVERS = "Covers";
    private boolean reading = true;
    private final FilterConfig config = new FilterConfig.Builder(this).allowedFilterModeWhitelist().allowedFilterTypeItemsAndFluids().filterTypeItems().filterSizeNine().compareDamageAndNbt().customFilterTypeSupplier(ft -> this.world.field_72995_K ? FilterType.values()[TileExporter.TYPE.getValue()] : ft).build();
    private final ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, slot -> {
        if (!this.reading && !this.getUpgradeHandler().hasUpgrade(10)) {
            int i;
            for (i = 0; i < this.config.getItemHandler().getSlots(); ++i) {
                ItemStack filteredItem = this.config.getItemHandler().getStackInSlot(i);
                if (filteredItem.func_190916_E() <= 1) continue;
                filteredItem.func_190920_e(1);
            }
            for (i = 0; i < this.config.getItemHandler().getSlots(); ++i) {
                FluidStack filteredFluid = this.config.getFluidHandler().getFluid(i);
                if (filteredFluid == null || filteredFluid.amount <= 0 || filteredFluid.amount == 1000) continue;
                filteredFluid.amount = 1000;
            }
        }
        this.markNetworkNodeDirty();
    }, 2, 3, 4, 10);
    private final CoverManager coverManager = new CoverManager(this);
    private int filterSlot;

    public NetworkNodeExporter(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.exporterUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNetworkNode() {
        super.updateNetworkNode();
        if (this.network != null && this.canUpdate() && this.ticks % this.upgrades.getSpeed() == 0) {
            if (this.config.isFilterTypeItem() && !this.config.getItemFilters().isEmpty()) {
                this.updateItemMode();
            } else if (this.config.isFilterTypeFluid() && !this.config.getFluidFilters().isEmpty()) {
                this.updateFluidMode();
            }
        }
    }

    private void updateItemMode() {
        IItemHandler handler = WorldUtils.getItemHandler(this.getFacingTile(), this.getDirection().func_176734_d());
        if (handler != null) {
            ItemStack slot;
            if (this.filterSlot >= this.getConfig().getItemFilters().size()) {
                this.filterSlot = 0;
            }
            if (!(slot = this.config.getItemFilters().get(this.filterSlot)).func_190926_b()) {
                int stackSize = this.upgrades.getItemInteractCount();
                if (this.upgrades.hasUpgrade(10)) {
                    stackSize = this.getStackInteractCountForRegulator(handler, slot, stackSize);
                }
                if (stackSize > 0) {
                    ItemStack took = this.network.extractItem(slot, Math.min(slot.func_77976_d(), stackSize), this.config.getCompare() | 8, Action.SIMULATE);
                    if (took.func_190926_b()) {
                        if (this.upgrades.hasUpgrade(3)) {
                            this.network.getCraftingManager().request((Object)new SlottedCraftingRequest(this, this.filterSlot), slot, (long)stackSize);
                        }
                    } else {
                        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)true);
                        int correctedStackSize = took.func_190916_E() - remainder.func_190916_E();
                        if (correctedStackSize > 0) {
                            took = this.network.extractItem(slot, correctedStackSize, this.config.getCompare() | 8, Action.PERFORM);
                            ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)false);
                        }
                    }
                }
            }
            ++this.filterSlot;
        }
    }

    private int getStackInteractCountForRegulator(IItemHandler handler, ItemStack slot, int stackSize) {
        int found = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stackInConnectedHandler = handler.getStackInSlot(i);
            if (!API.instance().getComparer().isEqual(slot, stackInConnectedHandler, this.config.getCompare())) continue;
            found += stackInConnectedHandler.func_190916_E();
        }
        int needed = 0;
        for (int i = 0; i < this.config.getItemFilters().size(); ++i) {
            if (!API.instance().getComparer().isEqualNoQuantity(slot, this.config.getItemFilters().get(i))) continue;
            needed += this.config.getItemFilters().get(i).func_190916_E();
        }
        return Math.min(stackSize, needed - found);
    }

    private void updateFluidMode() {
        StackListEntry<FluidStack> stackInStorage;
        IFluidHandler handler;
        List<FluidStack> fluids = this.config.getFluidFilters();
        if (this.filterSlot >= this.getConfig().getFluidFilters().size()) {
            this.filterSlot = 0;
        }
        if ((handler = WorldUtils.getFluidHandler(this.getFacingTile(), this.getDirection().func_176734_d())) == null) {
            return;
        }
        FluidStack stack = fluids.get(this.filterSlot);
        long toExtract = 1000L * (long)this.upgrades.getItemInteractCount();
        if (this.upgrades.hasUpgrade(10)) {
            int found = 0;
            for (int i = 0; i < handler.getTankProperties().length; ++i) {
                FluidStack stackInConnectedHandler = handler.getTankProperties()[i].getContents();
                if (!API.instance().getComparer().isEqual(stack, stackInConnectedHandler, this.config.getCompare())) continue;
                found += stackInConnectedHandler.amount;
            }
            int needed = 0;
            for (FluidStack fluid : fluids) {
                if (!API.instance().getComparer().isEqual(stack, fluid, 2)) continue;
                needed += fluid.amount;
            }
            toExtract = Math.min(toExtract, (long)(needed - found));
        }
        if ((stackInStorage = this.network.getFluidStorageCache().getList().getEntry(stack, this.config.getCompare())) != null) {
            int filled;
            StackListResult<FluidStack> took = this.network.extractFluid(stack, toExtract = Math.min(toExtract, stackInStorage.getCount()), this.config.getCompare(), Action.SIMULATE);
            if (took != null && (filled = handler.fill(took.getFixedStack(), false)) > 0 && (took = this.network.extractFluid(stack, (long)filled, this.config.getCompare(), Action.PERFORM)) != null) {
                handler.fill(took.getFixedStack(), true);
            }
        } else if (this.upgrades.hasUpgrade(3)) {
            this.network.getCraftingManager().request((Object)this, stack, toExtract);
        }
        ++this.filterSlot;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        tag.func_74782_a(NBT_COVERS, (NBTBase)this.coverManager.writeToNbt());
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
        if (tag.func_74764_b(NBT_COVERS)) {
            this.coverManager.readFromNbt(tag.func_150295_c(NBT_COVERS, 10));
        }
        this.reading = false;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.upgrades, this.coverManager.getAsInventory()});
    }

    @Override
    public boolean canConduct(@Nullable EnumFacing direction) {
        return this.coverManager.canConduct(direction);
    }

    @Override
    public CoverManager getCoverManager() {
        return this.coverManager;
    }

    @Override
    public ItemHandlerUpgrade getUpgradeHandler() {
        return this.upgrades;
    }

    @Override
    @Nonnull
    public FilterConfig getConfig() {
        return this.config;
    }
}

